DROP TABLE IF EXISTS `products_description`;
CREATE TABLE `products_description` (
	`products_id` int(11) NOT NULL AUTO_INCREMENT,
	`language_id` int(11) NOT NULL DEFAULT '1',
	`products_name` varchar(255) NOT NULL DEFAULT '',
	`products_description` text,
	`products_short_description` text,
	`products_keywords` varchar(255) DEFAULT NULL,
	`products_meta_title` text NOT NULL,
	`products_meta_description` text NOT NULL,
	`products_meta_keywords` text NOT NULL,
	`products_url` varchar(255) DEFAULT NULL,
	`products_viewed` int(5) DEFAULT '0',
	`gm_alt_text` varchar(255) DEFAULT NULL,
	`gm_url_keywords` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
	`checkout_information` text NOT NULL,
	PRIMARY KEY (`products_id`, `language_id`),
	KEY `products_name` (`products_name`),
	KEY `language_id` (`language_id`,`products_keywords`),
	KEY `language_id_2` (`language_id`,`products_name`),
	KEY `seo_boost_index` (`gm_url_keywords`,`products_id`,`language_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `products_description` (`products_id`, `language_id`, `products_name`, `products_description`, `products_short_description`, `products_keywords`, `products_meta_title`, `products_meta_description`, `products_meta_keywords`, `products_url`, `products_viewed`, `gm_alt_text`, `gm_url_keywords`, `checkout_information`)
VALUES
(1, 1, 'test article 1', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article', ''),
(1, 2, 'Testartikel 1', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel', ''),
(2, 1, 'test article 4', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article-2', ''),
(2, 2, 'Testartikel 4', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel-2', ''),
(3, 1, 'test article 6', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article-2-3', ''),
(3, 2, 'Testartikel 6', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel-2-3', ''),
(4, 1, 'test article 3', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article-4', ''),
(4, 2, 'Testartikel 3', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel-4', ''),
(5, 1, 'test article 2', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article-5', ''),
(5, 2, 'Testartikel 2', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel-5', ''),
(6, 1, 'test article 5', '<p>\r\n	test article description\r\n</p>', '<p>\r\n	test article short description\r\n</p>', '', '', '', '', '', 0, 'product image', 'test-article-6', ''),
(6, 2, 'Testartikel 5', '[TAB:Seite 1] Testartikel Beschreibung Seite 1 [TAB:Seite 2] Testartikel Beschreibung Seite 2 [TAB:Seite 3] Testartikel Beschreibung Seite 3', '<p>\r\n	Testartikel Kurzbeschreibung\r\n</p>', '', '', '', '', '', 0, 'Artikelbild', 'Testartikel-6', '');